 /**
 *
 * \file        HPRFGW_RFSlaveIntf.c
 *
 * \brief       This file contains the RF slave interface API functions.
 *
 * \detail
 *
 * \author      Hazrat Shah
 *
 * \date        11/28/2006
 * \warning
 * \note
 * \review
 */
#include <net/target.h>
#include <nucleus.h>
#include "nutypedefs.h"
// MNT - 3/21/2007 - Dependency Removal tag begin
//#include "console.h"
//#include "hprfgw_eeprom.h"
// MNT - 3/21/2007 - Dependency Removal tag end
#include "hprfgw_rfResultCode.h"
#include "hprfgw_rfHeartbeat.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfApp.h"
#include "hprfgw_rftrans.h"
#include "hprfgw_rfRec.h"
#include "hprfgw_rfRecMsg.h"
#include "hprfgw_rfComLog.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"
#include "hprfgw_cresnet.h"
#include "hprfgw_eeprom.h"
#include "hprfgw_leds.h"
#include "coordinating_task.h"
#include "ip_if.h"
#include "crc.h"

////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL
////////////////////////////////////////////////////////////////////////////////
extern	INT8   *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);

////////////////////////////////////////////////////////////////////////////////
//	DEFINITIONS
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//	LOCAL DATA
////////////////////////////////////////////////////////////////////////////////

INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrmode, UINT8 *defUID, UINT16 defPanid, UINT8 defAddrMode);
INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid);
INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID_ADDRMODE(UINT8 *pUID, UINT16 PANID, UINT8 AddrMode);
INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID);
INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID);
INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus);
INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr);
INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf);
INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count);
INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly);
INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Index);
INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel);
INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel);
INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel);
INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel);
INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres);
INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres);
INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset);
INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset);
INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout);
INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout);
INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate);
INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate);
INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID);
INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID);
INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count);
INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished);
INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdReq);
INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL CSStatus);
INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts);
INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index);
INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled);
INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled);
INT32	HOSTAPPINTERFACE_RFTxDebugTraceLevel (UINT8 *Level);
INT32	HOSTAPPINTERFACE_RFRxDebugTraceLevel (UINT8 *Level);
INT32   HOSTAPPINTERFACE_RFReceiverIndicatorFlash(void);
INT32   HOSTAPPINTERFACE_RFTransmitIndicatorFlash(void);
INT32	HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid);
INT32	HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid);
INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf);
INT32	HOSTAPPINTERFACE_GetDeviceDataField (UINT8 fieldno, INT8 *pbuf, UINT16 *plen);
INT32	HOSTAPPINTERFACE_GetDeviceDataField (UINT8 fieldno, INT8 *pbuf, UINT16 *plen);
INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pValid);
UINT16	RFAPPINTERFACE_ConnectDeviceToNetwork (UINT8 *pgatewayuid, UINT16 gatewaypanid, UINT8 channel, UINT8 addrmode);
INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count);
INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable (void);
INT32	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID (UINT8 *gwuid,UINT16 panid);


INT32 StartupWait(void);
INT32 ConsolePrintf(const char* format,...);
INT32 ErrorPrintf(const char* format,...);
INT32 ErrorHandler(char *msg);
INT32 HwDelayMsec(UINT32 ms);
INT32 UsecDelay(UINT32 ms);
INT32 GetTime(long *time);
INT32 GetDate(short *month,short *day,short *year);
INT32 SystemError(int error);
INT32 GetAddressMode(UINT8 *addrMode, UINT8 defAddrMode);
INT32 StoreAddressMode(UINT8 addrMode);
INT32 GetShortAddress(UINT16 *shortAddr, UINT16 defShortAddr);
INT32 StoreShortAddress(UINT16 shortAddr);
INT32 AcquireStartIndication(void);
INT32 AcquireStopIndication(void);

INT32 gettime(long *time);
INT32 getdate(short *month,short *day,short *year);
void HwDelayUsec(UINT16 ms);

INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI);
INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI);
INT32 HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount);
INT32 HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count);	

INT32 HOSTAPPINTERFACE_GetGatewayRoamingSupport(UINT8 *pGatewayRoamingSupport);
INT32 HOSTAPPINTERFACE_StoreGatewayRoamingSupport(UINT8 GatewayRoamingSupport);
INT32 HOSTAPPINTERFACE_GetPowerBoost(UINT8 *pPowerBoost);
INT32 HOSTAPPINTERFACE_StorePowerBoost (UINT8 PowerBoost);

const TYPE_INTERFACE_TO_HOST_APP RFIntHostApp = {
	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE,
	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID,
	HOSTAPPINTERFACE_StoreGatewayUID_PANID_ADDRMODE,
	HOSTAPPINTERFACE_StoreGatewayName,
	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID,
	HOSTAPPINTERFACE_StoreLocalDeviceUID,
	HOSTAPPINTERFACE_StoreLocalDevicePANID,
	HOSTAPPINTERFACE_ProcessCresnetPacket,
	HOSTAPPINTERFACE_LinkReply,
	HOSTAPPINTERFACE_RFCommunicationError,
	HOSTAPPINTERFACE_BufferOverFlows,
	HOSTAPPINTERFACE_ProcessLocalCresnetPacket,
	HOSTAPPINTERFACE_GetRetryCount,
    HOSTAPPINTERFACE_StoreRetryCount,
	HOSTAPPINTERFACE_GetRetryDelay,
	HOSTAPPINTERFACE_StoreRetryDelay,
	HOSTAPPINTERFACE_GetPowerLevel,
	HOSTAPPINTERFACE_StorePowerLevel,
	HOSTAPPINTERFACE_GetChannel,
	HOSTAPPINTERFACE_StoreChannel,
	HOSTAPPINTERFACE_GetCCAEnergyDetectThr,
	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr,
	HOSTAPPINTERFACE_GetRSSIPowerCompOffset,
	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset,
	HOSTAPPINTERFACE_GetResultCodeTimeout,
	HOSTAPPINTERFACE_StoreResultCodeTimeout,
	HOSTAPPINTERFACE_GetHeartBeatRate,
	HOSTAPPINTERFACE_StoreHeartBeatRate,
	HOSTAPPINTERFACE_GetIDString,
	HOSTAPPINTERFACE_AcquireUpdate,
	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange,
	HOSTAPPINTERFACE_GatewayConnectionStatusChange,
	HOSTAPPINTERFACE_GetRFID,
	HOSTAPPINTERFACE_GetTSID,
	HOSTAPPINTERFACE_GetDeviceOptions,
	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured,
	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled,
	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled,
	HOSTAPPINTERFACE_RFReceiverIndicatorFlash,
	HOSTAPPINTERFACE_RFTransmitIndicatorFlash,
	HOSTAPPINTERFACE_DeviceLinkLost,
	HOSTAPPINTERFACE_DeviceLinkFound,
	HOSTAPPINTERFACE_CalculateBlockCRC16,
	HOSTAPPINTERFACE_GetDeviceDataField,
  
	StartupWait,
	ConsolePrintf,
	ErrorPrintf,
	ErrorHandler,
	HwDelayMsec,
	UsecDelay,
	GetTime,
	GetDate,
	SystemError,
	GetAddressMode,
	StoreAddressMode,
	GetShortAddress,
	StoreShortAddress,
	AcquireStartIndication,
	AcquireStopIndication,
  
	HOSTAPPINTERFACE_IsUIDValid,
	HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr,	
	HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr,	
	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq,	
	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq,	
	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt,
	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt,
#ifndef	RF_NETWORK_MASTER_DEVICE
        HOSTAPPINTERFACE_InitRoamingDescriptiveTable, 
	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID, 
#else
	HOSTAPPINTERFACE_GetGatewayRoamingSupport,
	HOSTAPPINTERFACE_StoreGatewayRoamingSupport,
	HOSTAPPINTERFACE_GetPowerBoost,
	HOSTAPPINTERFACE_StorePowerBoost,
#endif
};

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////


//=========================== TEST PURPOSE CREATE HOST APIs (TILL HOST IS AVALIABLE) ======================================================


// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// MNT - 3/21/2007 - Make sure that these functions do something. Most of the stuff is
// commented out but it should give the device developer an idea of what needs to be
// returned. All the EEProm Entries are specifically commented out for the user to define
// what that means (store in file system/nvram or whatever else makes sense)
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrMode, UINT8 *defUID, UINT16 defPanid, UINT8 defaddrMode)	{

	//	Retreive from local device eeprom
	EEpromGetSlaveDeviceGatewayUID (pUID);
	EEpromGetSlaveDeviceGatewayPanID (pPanid);
	EEpromGetSlaveDeviceGatewayAddrMode (pAddrMode);

	*pUIDValid = TRUE;

  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUidValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid){
	UINT32 signature;

	EEpromGetUID   (pUID);
	EEpromGetPanID (pPanid);
	EEpromGetUIDSignature (&signature);
	if (signature == VALID_UID_SIGNATURE)
  {
    *pUidValid = TRUE;
  }
  else
  {
    *pUidValid = FALSE;
    memcpy(pUID, defUID, UID_MAX_SIZE);
    *pPanid = defPanid;
  }

  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID_ADDRMODE(UINT8 *pUID, UINT16 PANID, UINT8 AddrMode){
	INT32 res = SUCCESS;

  res = (INT32)EEpromSaveUID (pUID);
  if (res == SUCCESS)
  {
    res = (INT32)EEpromSavePanID(PANID);
  }
  if (res == SUCCESS)
  {
    res = (INT32)EEpromSaveAddrMode(AddrMode);
  }
  if (res == SUCCESS)
  {
	  res = (INT32)EEpromSaveUIDSignature (VALID_UID_SIGNATURE);
  }

  return res;
}
/**
 * \author      John Cheng
 *
 * \date        12/01/2008
 *
 * \return      UINT16
 *
 * \retval      
 *
 * \brief		get gateway roaming support falg 
 *
 * \param       UINT8 *pGatewayRoamingSupport
 *
 * \note
 *
 * \warning
 *
 */
INT32	HOSTAPPINTERFACE_GetGatewayRoamingSupport(UINT8 *pGatewayRoamingSupport){
  EEpromGetGatewayRoamingSupport (pGatewayRoamingSupport);
  return SUCCESS;
}
/**
 * \author      John Cheng
 *
 * \date        12/01/2008
 *
 * \return      UINT16
 *
 * \retval      
 *
 * \brief		get power boost 
 *
 * \param       UINT8 *pPowerBoost
 *
 * \note
 *
 * \warning
 *
 */
INT32	HOSTAPPINTERFACE_GetPowerBoost(UINT8 *pPowerBoost){
  EEpromGetPowerBoost(pPowerBoost);
  return SUCCESS;
}
/**
 * \author      John Cheng
 *
 * \date        12/01/2008
 *
 * \return      UINT16
 *
 * \retval      
 *
 * \brief		save gateway roaming support falg 
 *
 * \param       UINT8 GatewayRoamingSupport
 *
 * \note
 *
 * \warning
 *
 */
INT32	HOSTAPPINTERFACE_StoreGatewayRoamingSupport (UINT8 GatewayRoamingSupport)	{
  INT32 res = (INT32)	EEpromSaveGatewayRoamingSupport (GatewayRoamingSupport);
  return res;
}
/**
 * \author      John Cheng
 *
 * \date        12/01/2008
 *
 * \return      UINT16
 *
 * \retval      
 *
 * \brief		save power boost 
 *
 * \param       UINT8 PowerBoost
 *
 * \note
 *
 * \warning
 *
 */
INT32	HOSTAPPINTERFACE_StorePowerBoost (UINT8 PowerBoost)	{
  INT32 res = (INT32)	EEpromSavePowerBoost(PowerBoost);
  return res;
}
INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName)	{

  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID)
{
	INT32 res = FAILURE;

	if (SUCCESS == (INT32) EEpromSaveUID (pUID))	{
		res = (INT32) EEpromSaveUIDSignature (VALID_UID_SIGNATURE);
	}

	return res;
}

INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID)
{
	return ((INT32) EEpromSavePanID (PANID));
}


INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID)
{
	INT32 res1, res2;

	res1 = HOSTAPPINTERFACE_StoreLocalDeviceUID(pUID);
	res2 = HOSTAPPINTERFACE_StoreLocalDevicePANID(PANID);

	return (((res1==SUCCESS)&&(res2==SUCCESS))?SUCCESS:FAILURE);
}

INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen){

 return (INT32)(CresnetTxPostPackettoCresnet(pBuf, BufLen));

}

INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus){
	//ConsolePrintf("Link reply Linked=%d, CSStatus=%d\r\n", Linked, CSStatus);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr){
	//ConsolePrintf("CommError SeqErr=%d, SegErr=%d\r\n", SeqErr, SegErr);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf){
	//ConsolePrintf("Bufferoverflow TxBuf=%d, RxBuf=%d\r\n", TxBuf, RxBuf);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen){
	//ConsolePrintf("Local Cresnet packet Len=%02x, data=%02x%02x%02x%02x\r\n", BufLen, *pBuf, *(pBuf+1), *(pBuf+2), *(pBuf+3));
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount){
	INT32 res = (INT32)EEpromGetRetry		((UINT8 *)  count);
//  *count = defCount;
	return res;
}

INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count)
{
  INT32 res = (INT32)EEpromSaveRetry(count);
  return res;
}

INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly){
	//memcpy(RetryDly, defRetryDly, Cnt);
  INT32 res = (INT32)EEpromGetRetryDelay(Cnt,RetryDly);
  return res;
}

INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Index)
{
  INT32 res = (INT32)EEpromSaveRetryDelay(Index, RetryDly);
  return res;
}



INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel){
  INT32 res = EEpromGetPower(powerLevel);
  return res;
}

INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel)
{
  INT32 res = (INT32)EEpromSavePower(powerLevel);
  return res;
}


INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel){
	EEpromGetChannel (Channel);
  //*Channel = defChannel;
  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel)	{
  INT32 res = (INT32)	EEpromSaveChannel (Channel);
  return res;
}

INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres){
  INT32 res = (INT32)EEpromGetCCAEnergyDetectThr(ccaThres);
	//*ccaThres = defCcaThres;
  return res;
}

INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres){
	INT32 res = (INT32) EEpromSaveCCAEnergyDetectThr(ccaThres);
  return res;
}

INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset){
	INT32 res = (INT32)EEpromGetRSSIPowerCompOffset(rssiOffset);
	//*rssiOffset = defRssiOffset;
  return res;
}


INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset){
	INT32 res = EEpromSaveRSSIPowerCompOffset(rssiOffset);
  return res;
}


INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout){
	INT32 res = (INT32)EEpromGetResultCodeTimeout (timeout);
	//*timeout = defTimeout;
  return res;
}

INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout)
{
  INT32 res = (INT32) EEpromSaveResultCodeTimeout(timeout);
  return res;
}


INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate){
	INT32 res = (INT32) EEpromGetHeartBeatTimeout (heartBeatRate);
	//*heartBeatRate = defHeartBeatRate;
	return res;
}

INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate){
	INT32 res = (INT32)EEpromSaveHeartBeatTimeout (heartBeatRate);
	return res;
}


INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count){
  // for slave devices the cresnet id string is returned 

  // test case (add a sep interface call that rets the host name)
  GetHostname(pBuf, RF_DEVICE_MAX_CRESNET_ID_STRING_LEN-2);

  *count = strlen(pBuf);

  return SUCCESS;

}

INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished)	{
	INT8	buf[30], i;
	INT32	res = FAILURE;
	BOOL	valid;
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;

	//if (Finished)	{
		//	Note: 1- stop acquire after timeout, timeout occurs  a) no gateway found, b) list of gatewayes found
		//			 The user can then select which gateway is the correct gateway for this device
		//		  2- stop acquire when one gateway is found
	if (NoofAcquireEntries)	{
		for (i=0; i<NoofAcquireEntries; i++, pAcquireResult++)	{
				ConsolePrintf("\r\nGateway acquired: name[%s] uid[%s] panid[%04x] channel[%02x]\r\n", (INT8*)&pAcquireResult->name,
								ConvertUIDtoString((UINT8*)&pAcquireResult->uid, buf, gAddrModeLong_c), pAcquireResult->panid,
								pAcquireResult->channel);

			if (i == 0)	{
				EEpromSaveSlaveDeviceGatewayUID		((UINT8*)&pAcquireResult->uid);
				EEpromSaveSlaveDeviceGatewayPanID	((UINT16) pAcquireResult->panid);
					EEpromSaveChannel ((UINT8) pAcquireResult->channel);
					//	set, local panid to the gateway panid
					RFIntHostApp.pF_GetLocalDeviceUID_PANID (&valid, uid, &panid, (UINT8 *)SLAVE_DEVICE_DEFAULT_UID, SLAVE_DEVICE_DEFAULT_PANID);
					RFIntRFApp.pF_SetLocaldeviceUID_PANID (valid, uid, pAcquireResult->panid);
					//RFIntHostApp.pF_StoreLocalDevicePANID (pAcquireResult->panid);
					res = SUCCESS;
				}
		}
	}	else	{
		//ConsolePrintf("Acquire done: no gateway found in acquire mode\r\n");
	}
		RFIntRFApp.pF_AcquireStop(TRUE);
	//}

	return res;
}

INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdReq)	{
	UINT8 i;
	INT8 buf[300];
	UINT8 id;

	if (CSStatus)	{
		//	control system connected
	}	else	{
		//	control system disconnected
	}

	//ConsolePrintf("Host: Control System connection status = %x \r\n", CSStatus);
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL Status)	{
	if (Status)	{
		//	gateway connection established
		RFIntRFApp.pF_PrepareAndPostDeviceDataInfoStr (RF_DEVICE_INFO_CRC_FIELD_INDEX);
	}	else	{
		//	gateway connection lost
	}

	//ConsolePrintf("Host: Gateway connection status = %x \r\n", Status);
  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID){
	EEpromGetCNETID (rfID);
  return SUCCESS;

}

INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID){
  EEpromGetTSID (tsID);
  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts)	{
	*devOpts = 0x11;
  return SUCCESS;
}

INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index)	{
	#ifdef	RF_NETWORK_MASTER_DEVICE
		INT8 buf[200];
	
		//	Send error code to the control system
		sprintf(buf, "Error %02x: rf transmit task pipe overflow occured", 0);
		CresnetTxBuildErrorSerialPacketAndPostToPipe (buf, strlen(buf));
		//	Report this condition to the specific RF Device
		RFTransmit_BuildBufferOverflowPacketAndPostToPipeByIndex (index, TRUE, FALSE);
	#else
		//	slave action
	#endif
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled)	{
  *isEnabled = (BOOL)DebugTraceIsRFTxTraceEnabled();
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled)	{
  *isEnabled = (BOOL)DebugTraceIsRFRxTraceEnabled();
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_RFTxDebugTraceLevel (UINT8 *Level)	{
	*Level = (UINT8)DebugTraceIsRFTxTraceEnabled();
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_RFRxDebugTraceLevel (UINT8 *Level)	{
	*Level = (UINT8)DebugTraceIsRFRxTraceEnabled();
	return SUCCESS;
}

INT32  GetAddressMode(UINT8 *mode, UINT8 defAddrMode)
{
	INT32 res = (INT32)EEpromGetAddrMode 	((UINT8 *) mode);
  return res;
}

INT32 StoreAddressMode(UINT8 addrMode)
{
  INT32 res = EEpromSaveAddrMode(addrMode);
  return res;
}



INT32  GetShortAddress(UINT16 *addr, UINT16 defShortAddr)
{
	EEpromGetShortAddr 	((UINT16 *) addr);
  return SUCCESS;

}

INT32  StoreShortAddress(UINT16 shortAddr)
{
  INT32  res = (INT32)EEpromSaveShortAddr(shortAddr);
  return res;
}


INT32 GetDate(short *month,short *day,short *year)
{
  getdate(month, day, year);
  return SUCCESS;
}



INT32 GetTime(long *time)
{
  *time = NU_Retrieve_Clock();
  return SUCCESS;
}


INT32 AcquireStartIndication(void)
{
  LED_Control(ACQUIRE_LED, LED_ON, 0);
  return SUCCESS;
}
INT32 AcquireStopIndication(void)
{
	//	Turn off acquire state indicator
	LED_Control(ACQUIRE_LED, LED_OFF, 0);
	
	ConsolePrintf ("\xFA\xB1 Acquire Ended.\xFB\r\n");
	return SUCCESS;
}


/**
 *
 * \date        05-21-2007
 *
 * \author      mtalreja
 *
 * \brief       UsecDelay
 *
 * \detail      This takes in a UINT32 but only delays it for a UINT16 time
 *              Fix this if it causes a problem.
 *
 * \return      What is returned
 *
 * \retval
 *
 * \param ms
 * \return
 */
INT32 UsecDelay(UINT32 ms)
{
  if (ms>0xFFFF)
{
    HwDelayUsec(0xFFFF);
  }
  else
  {
    HwDelayUsec(ms);
  }

  return SUCCESS;

}

/**
 *
 * \date        05-30-2007
 *
 * \author      hazrat shah
 *
 * \brief       this function turns on the rf receiver indicator for xmsec
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param void
 * \return
 */
INT32	HOSTAPPINTERFACE_RFReceiverIndicatorFlash (void)	{
	LED_Control(RFRX_LED, LED_PULSE, 1);
	return (SUCCESS);
}

/**
 *
 * \date        05-30-2007
 *
 * \author      hazrat shah
 *
 * \brief       this function turns on the rf transmit indicator for xmsec
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		void
 * \return
 */
INT32 HOSTAPPINTERFACE_RFTransmitIndicatorFlash (void)	{
	LED_Control(RFTX_LED, LED_PULSE, 1);
	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function is called when an device rf link is lost
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		void
 * \return
 */
INT32 HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid)	{
	BOOL isEnabled;
	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (&isEnabled);

	if (isEnabled)	{
		ConsolePrintf ("RFDevice [%02X] Link Lost\r\n", rfid);
	}

#ifdef  RF_NETWORK_MASTER_DEVICE
report_panel_gone(rfid);  // inform the image server
#endif  /* #ifdef  RF_NETWORK_MASTER_DEVICE */
	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function is called when an rf device is linked
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		void
 * \return
 */
INT32 HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid)	{
	BOOL isEnabled;
	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (&isEnabled);

#ifdef  RF_NETWORK_MASTER_DEVICE
report_panel_gone(rfid);  // inform the image server
#endif  /* #ifdef  RF_NETWORK_MASTER_DEVICE */

	if (isEnabled)	{
		ConsolePrintf ("RFDevice [%02X] Linked \r\n", rfid);
	}

	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function gets device data field information from the host application
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS/FAILURE
 *
 * \param		UINT8 field, INT8 *pbuf, UINT16 *len
 *
 * \return
 */
INT32 HOSTAPPINTERFACE_GetDeviceDataField (UINT8 field, INT8 *pbuf, UINT16 *plen)	{

	//	test
	if (field < RF_DEVICE_INFO_MAX_DATA_FIELDS){
		*plen = sprintf (pbuf, "test string field %d 123", field);
	}	else	{
		*pbuf = 0;	*plen = 0;
	}

	return (SUCCESS);
}

/**
 *
 * \date        06-07-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function calculate the passed ob block CRC
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval
 *
 * \param		UINT16 *crc, INT8 *pbuf, UINT16 len
 *
 * \return
 */
INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf)	{
	unsigned short int calccrc = CalculateBlockCRC16( len, *crc, (void*)pbuf);

	*crc =  calccrc;
	return (SUCCESS);
}

/**
 *
 * \date        07-26-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function checks whether the UID is valid 
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		void
 *
 * \return
 */
INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pUIDValid)	{
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;	

	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(pUIDValid, uid, &panid, (UINT8 *)SLAVE_DEVICE_DEFAULT_UID, SLAVE_DEVICE_DEFAULT_PANID);
	
	return (SUCCESS);
}

/**
 *
 * \date        09-25-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function retrieves the link process LQI threshold from host
 *				
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		UINT8 *pLQI, UINT8 defaultLQI
 *
 * \return
 */
INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI)	{
	INT32	res;
	res = (INT32)EEpromGetRFLinkLQIThr(pLQI);
	return (res);	
}

/**
 *
 * \date        09-25-2007
 *
 * \author      hazrat shah
 *
 * \brief       This function saves the link process LQI threshold  
 *
 * \detail
 *
 * \return      INT32
 *
 * \retval		SUCCESS, FAILURE
 *
 * \param		UINT8 LQI
 *
 * \return
 */
INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI)	{
	INT32	res;
	res = (INT32)EEpromSaveRFLinkLQIThr(LQI);
	return (res);	

}

INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount)	{
	INT32 res = (INT32)EEpromGetRetryOnConnectionReq ((UINT8 *)  count);
//  *count = defCount;
	return res;
}

INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count)	{
  INT32 res = (INT32)EEpromSaveRetryOnConnectionReq(count);
  return res;
}

INT32	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount)	{
	INT32 res = (INT32)EEpromGetPreLinkQueryPacketCnt ((UINT8*)  count);
	//  *count = defCount;
	return res;
}

INT32	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count)	{
	INT32 res = (INT32)EEpromSavePreLinkQueryPacketCnt(count);
	return res;
}

INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable(void)	{
	INT32 res = SUCCESS;    
    //RF_RetrieveRoamingGatewayUID_PANID();
	//RF_RetrieveRoamingGatewayName();
	//RF_RoamingGatewayLQReset();
	return res;
}

INT32   HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID(UINT8 *gwuid,UINT16 panid)
{
	INT32 res = SUCCESS;    
    //RF_SetRoamingGatewayUID_PANID(gwuid,panid);
	return res;
}